<?php
namespace lib;

require \Pawn::helper('template');

abstract class Template
{
	public static function render($template_file, $vars=array())
	{
		self::vars($vars);
		
		extract(self::$vars);
		
		require \Pawn::cache('view/'.$template_file, array('\\lib\\Template', 'parse'));
	}
	
	private static function absolute($relative, $file)
	{
		if(strlen(FW) > strlen(ROOT))
		{
			$path = (substr($relative, 0, strlen(FW)) == FW)?FW:ROOT;
		} else
		{
			$path = (substr($relative, 0, strlen(ROOT)) == ROOT)?ROOT:FW;
		}
		
		$file{0} == '/' or $file = dirname(substr($relative, strlen($path) + 5)).'/'.$file;
		
		$path = 'view/'.$file;
		
		return file_exists(ROOT.$path)?ROOT.$path:FW.$path;
	}
	
	// Parse
	public static function parse($file, $depth=0, $blocks=array(), $filename=null)
	{
		if(!file_exists($file))
		{
			throw new \Pawn\Exception('Template', $file.' does not exist.');
		}
		
		# File
		$cache = file_get_contents($file);
		$extends = preg_match('/\{%( +)extends( +)(\"|\')(.*)(\"|\')( +)%\}/U', $cache, $extension);
		
		# Include
		preg_match_all('/\{\%( +)include( +)(\"|\')(.*)(\"|\')( +)(with( +)(.*)( +))?%\}/U', $cache, $include);
		
		foreach($include[0] as $i=>$match)
		{
			$path = self::absolute($file, $include[4][$i]);
			
			if(!file_exists($path))
			{
				throw new \Pawn\Exception('Template', "Included file ".$include[4][$i]." doesn't exist.", $file, false);
			}
			
			if($include[9][$i])
			{
				$fn = 'include_'.md5($path);
				
				$content = '<?php $tmp_fn = function($vars){ extract($vars); ?>'.file_get_contents($path).'<?php }; $tmp_fn('.self::line($include[9][$i]).'); ?>';
			} else
			{
				$content = file_get_contents($path);
			}
			
			$cache = str_replace($match, $content, $cache);
		}
		
		# Blocks
		while(preg_match('/\{%( +)block( +)(\w+)( +)%\}/', $cache, $block, PREG_OFFSET_CAPTURE))
		{
			$start = $end = strlen($block[0][0]) + $block[0][1];
			
			$skip = 0;
			
			do
			{
				$open = strpos($cache, '{% block ', $end);
				$close = strpos($cache, '{% endblock %}', $end);
				
				if($close === false)
				{
					throw new \Pawn\Exception('Template', 'Block '.$block[3][0].' is not closed.', $file, false, 301);
				}
				
				if($open !== false && $open < $close)
				{
					$skip++;
					
					if(!$depth)
					{
						throw new \Pawn\Exception('Template', 'Unexpected block '.substr($cache, $open + 9, strpos($cache, ' ', $open + 9) - $open - 9).'.', $file, count(explode("\n", substr($cache, 0, $open))), 302);
					}
				}
				{
					$skip--;
				}
				
				$end = $close + 14;
			} while($skip >= 0);
			
			$content = substr($cache, $start, $end - $start - 14);
			
			if(!isset($blocks[$block[3][0]]))
			{
				$blocks[$block[3][0]] = $content;
			} else
			{
				$blocks[$block[3][0]] = preg_replace('/\{\{( *)parent\(\)( *)\}\}/', $content, $blocks[$block[3][0]]);
			}
			
			$cache = substr($cache, 0, $block[0][1]).$blocks[$block[3][0]].substr($cache, $end);
		}
		
		# Extends
		if($extends)
		{
			$name = self::absolute($file, $extension[4]);
			
			return self::parse($name, $depth + 1, $blocks, $filename?$filename:$file);
		}
		
		# Conditional
		preg_match_all('/\{\%( +)(el)?if( +)(.*)( +)\%\}/eU', $cache, $conditional);
		
		foreach($conditional[0] as $i=>$match)
		{
			$cache = str_replace($match, '<?php '.($conditional[2][$i]?'} else':'').'if('.self::line($conditional[4][$i]).'){ ?>', $cache);
		}
		
		$cache = preg_replace('/\{\%( +)else( +)\%\}/', '<?php } else { ?>', $cache);
		$cache = preg_replace('/\{\%( +)endif( +)\%\}/', '<?php } ?>', $cache);
		
		# Foreach
		preg_match_all('/\{\%( +)for( +)([\w]+)(,([\w]+))?( +)in( +)([\w\.]+)( +)(\(([\w]+)\)( +))?\%\}/', $cache, $loops);
		
		foreach($loops[0] as $i=>$match)
		{
			$replacement = '<?php $tmp_array'.$i.' = '.self::line($loops[8][$i]).'; ';
			
			if($loops[11][$i])
			{
				$replacement .= '$'.$loops[11][$i].' = 0; ';
			}
			
			$replacement .= 'if(is_array($tmp_array'.$i.') && sizeof($tmp_array'.$i.')){ foreach($tmp_array'.$i.' as $'.$loops[3][$i];
			
			if($loops[4][$i])
			{
				$replacement .= '=>$'.$loops[5][$i];
			}
			
			if($loops[11][$i])
			{
				$replacement .= '){ $'.$loops[11][$i].'++; ?>';
			} else
			{
				$replacement .= '){ ?>';
			}
			
			$cache = str_replace($match, $replacement, $cache);
		}
		
		$cache = preg_replace('/\{\%( +)endfor( +)\%\}/', '<?php }} ?>', $cache);
		
		# Repeat
		preg_match_all('/\{\%( +)repeat( +)(.*)( +)(\((\w+)\)( +))?\%\}/U', $cache, $repeats);
		
		foreach($repeats[0] as $i=>$match)
		{
			$var = $repeats[6][$i]?$repeats[6][$i]:'tmp_repeat'.$i;
			
			$cache = str_replace($match, '<?php for($'.$var.'=1; $'.$var.'<='.self::line($repeats[3][$i]).'; $'.$var.'++){ ?>', $cache);
		}
		
		$cache = preg_replace('/\{\%( +)endrepeat( +)\%\}/', '<?php } ?>', $cache);
		
		# Raw output
		while(preg_match('/\{\[(.*)\]\}/U', $cache, $command, PREG_OFFSET_CAPTURE))
		{
			try
			{
				$cache = substr($cache, 0, $command[0][1]).'<?php echo '.self::line($command[1][0]).'; ?>'.substr($cache, $command[0][1] + strlen($command[0][0]));
			} catch(\Exception $e)
			{
				throw new \Pawn\Exception('Template', $e->getMessage(), $filename, false);
			}
		}
		
		# Echo
		while(preg_match('/\{\{(.*)\}\}/U', $cache, $command, PREG_OFFSET_CAPTURE))
		{
			try
			{
				$cache = substr($cache, 0, $command[0][1]).'<?php echo usertext('.self::line($command[1][0]).'); ?>'.substr($cache, $command[0][1] + strlen($command[0][0]));
			} catch(\Exception $e)
			{
				throw new \Pawn\Exception('Template', $e->getMessage(), $filename, false);
			}
		}
		
		return $cache;
	}
	
	private static function line($line)
	{
		$parse = '';
		
		$tmp = '';
		$get = false;
		$args = false;
		
		$length = strlen($line);
		
		for($i=0; $i<$length; $i++)
		{
			switch($line{$i})
			{
				default:
					if(is_numeric($line{$i}) && !$tmp)
					{
						$parse .= $line{$i};
					} else
					{
						$tmp .= $line{$i};
					}
				break;
				case ' ':
				break;
				case '(':
					if($get)
					{
						$args = true;
						
						$parse .= ', "'.$tmp.'", array(';
					} else
					{
						$parse .= $tmp.'(';
					}
					
					$tmp = '';
				break;
				case ')':
				case ',':
				case '=':
				case '&':
				case '|':
				case '+':
				case '-':
				case '/':
				case '*':
				case '<':
				case '>':
				case '!':
					if($tmp)
					{
						if($args)
						{
							$parse .= ', $'.$tmp;
							
							if($line{$i} == ')')
							{
								$parse .= ')';
							}
						} elseif($get)
						{
							$parse .= ', "'.$tmp.'")';
							
							$get = false;
						} else
						{
							$parse .= '$'.$tmp;
						}
						
						$parse .= $line{$i};
						
						$tmp = '';
					} elseif(!$args)
					{
						$parse .= $line{$i};
					} elseif($line{$i} == ')')
					{
						$parse .= '))';
						
						$get = false;
						$args = false;
					} else
					{
						$parse .= $line{$i};
					}
				break;
				case '.':
					if($tmp)
					{
						if($get)
						{
							$parse .= ', "'.$tmp.'"';
						} else
						{
							$get = true;
							
							$parse .= '@get($'.$tmp;
						}
						
						$tmp = '';
					} else
					{
						$parse .= '.';
					}
				break;
				case '"':
				case '\'':
					$end = $i + 1;
					
					while(true)
					{
						if(($end = strpos($line, $line{$i}, $end)) === false)
						{
							throw new \Pawn\Exception('Template', 'Unfinished quotation.');
						} else
						{
							if($line{$end-1} == '\\')
							{
								$end++;
							} else
							{
								break;
							}
						}
					}
					
					$parse .= substr($line, $i, $end - $i + 1);
					
					$i = $end;
				break;
				case '{':
					$parse .= 'array(';
				break;
				case '}':
					if($tmp)
					{
						if($get)
						{
							$parse .= ', "'.$tmp.'")';
						} else
						{
							$parse .= '$'.$tmp;
						}
						
						$tmp = '';
					}
					
					$parse .= ')';
				break;
				case ':':
					$parse .= '=>';
				break;
			}
		}
		
		if($tmp)
		{
			if($get)
			{
				$parse .= ', "'.$tmp.'")';
			} else
			{
				$parse .= '$'.$tmp;
			}
		}
		
		return $parse;
	}
	
	// Vars
	private static $vars = array();
	
	public static function vars($vars, $value=null)
	{
		if($value !== null)
		{
			$vars = array($vars=>$value);
		}
		
		\Pawn::merge(self::$vars, $vars);
	}
	
	// Public
	public static function public_file($file)
	{
		$locations = array
		(
			'public/template/'.\Pawn::setting('template').'/',
			'public/',
			'fw/public/'
		);
		
		foreach($locations as $location)
		{
			if(file_exists(ROOT.$location.$file))
			{
				return $location.$file;
			}
		}
		
		throw new \Pawn\Exception('Template', $file.' does not exist.');
	}
	
	public static function css_var($theme, $path)
	{
		$path = explode('.', $path);
		
		foreach($path as $key)
		{
			$theme = $theme[$key];
		}
		
		return $theme;
	}
	
	public static function css($file)
	{
		$cache = file_get_contents($file);
		
		# Vars
		$theme = 'public/template/'.\Pawn::setting('template').'/theme.yml';
		
		if(file_exists(ROOT.$theme))
		{
			$theme = \Pawn::config($theme);
			
			preg_match_all('/var\((.*)\)/U', $cache, $vars);
			
			foreach($vars[0] as $i=>$match)
			{
				$cache = str_replace($match, self::css_var($theme, $vars[1][$i]), $cache);
			}
		}
		
		# Size
		preg_match_all('/(width|height)\((.*)\)/U', $cache, $functions);
		
		foreach($functions[0] as $i=>$match)
		{
			list($width, $height) = getimagesize(ROOT.self::public_file($functions[2][$i]));
			
			$cache = str_replace($match, $$functions[1][$i], $cache);
		}
		
		# Eval
		preg_match_all('/eval\(([\d\+\-\*\/]+)\)/U', $cache, $evals);
		
		foreach($evals[0] as $i=>$match)
		{
			$cache = str_replace($match, eval('return '.$evals[1][$i].';'), $cache);
		}
		
		# Urls
		preg_match_all('/url\((.*)\)/U', $cache, $urls);
		
		foreach($urls[0] as $i=>$match)
		{
			$path = self::public_file($urls[1][$i]);
			
			$cache = str_replace($match, 'url(../'.$path.'?'.time().')', $cache);
		}
		
		return $cache;
	}
}

# Autoload
global $autoload;

if(isset($autoload['Session']))
{
	Template::vars($autoload['Session']);
}